package cn.datax.service.data.metadata.controller;

import cn.datax.common.core.R;
import cn.datax.service.data.metadata.service.DataMetadataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = {"元数据"})
@RestController
public class DataMetadataController {

    @Autowired
    private DataMetadataService dataMetadataService;

    @ApiOperation(value = "同步", notes = "根据url的id来指定同步对象")
    @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path")
    @PostMapping("/databases/{id}")
    public R syncMetadata(@PathVariable String id) {
        dataMetadataService.syncMetadata(id);
        return R.ok();
    }
}
