package cn.datax.service.system.service.impl;

import cn.datax.service.system.api.entity.DictItemEntity;
import cn.datax.service.system.api.dto.DictItemDto;
import cn.datax.service.system.service.DictItemService;
import cn.datax.service.system.mapstruct.DictItemMapper;
import cn.datax.service.system.dao.DictItemDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 * 字典项信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-04-17
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class DictItemServiceImpl extends BaseServiceImpl<DictItemDao, DictItemEntity> implements DictItemService {

    @Autowired
    private DictItemDao dictItemDao;

    @Autowired
    private DictItemMapper dictItemMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveDictItem(DictItemDto dictItemDto) {
        DictItemEntity dictItem = dictItemMapper.toEntity(dictItemDto);
        dictItemDao.insert(dictItem);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDictItem(DictItemDto dictItemDto) {
        DictItemEntity dictItem = dictItemMapper.toEntity(dictItemDto);
        dictItemDao.updateById(dictItem);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDictItemById(String id) {
        dictItemDao.deleteById(id);
    }
}
