package cn.datax.service.system.controller;

import cn.datax.common.core.JsonPage;
import cn.datax.common.core.R;
import cn.datax.common.validate.ValidationGroups;
import cn.datax.service.system.api.dto.WorkflowConfigDto;
import cn.datax.service.system.api.entity.WorkflowConfigEntity;
import cn.datax.service.system.api.vo.WorkflowConfigVo;
import cn.datax.service.system.api.query.WorkflowConfigQuery;
import cn.datax.service.system.mapstruct.WorkflowConfigMapper;
import cn.datax.service.system.service.WorkflowConfigService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 工作流配置信息表 前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2020-05-19
 */
@Api(tags = {"工作流配置信息表"})
@RestController
@RequestMapping("/workflowConfigs")
public class WorkflowConfigController extends BaseController {

    @Autowired
    private WorkflowConfigService workflowConfigService;

    @Autowired
    private WorkflowConfigMapper workflowConfigMapper;

    /**
     * 通过ID查询信息
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "获取详细信息", notes = "根据url的id来获取详细信息")
    @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path")
    @GetMapping("/{id}")
    public R getWorkflowConfigById(@PathVariable String id) {
        WorkflowConfigEntity workflowConfigEntity = workflowConfigService.getWorkflowConfigById(id);
        return R.ok().setData(workflowConfigMapper.toVO(workflowConfigEntity));
    }

    /**
     * 分页查询信息
     *
     * @param workflowConfigQuery
     * @return
     */
    @ApiOperation(value = "分页查询", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "workflowConfigQuery", value = "查询实体workflowConfigQuery", required = true, dataTypeClass = WorkflowConfigQuery.class)
    })
    @GetMapping("/page")
    public R getWorkflowConfigPage(WorkflowConfigQuery workflowConfigQuery) {
        QueryWrapper<WorkflowConfigEntity> queryWrapper = new QueryWrapper<>();
        IPage<WorkflowConfigEntity> page = workflowConfigService.page(new Page<>(workflowConfigQuery.getPageNum(), workflowConfigQuery.getPageSize()), queryWrapper);
        List<WorkflowConfigVo> collect = page.getRecords().stream().map(workflowConfigMapper::toVO).collect(Collectors.toList());
        JsonPage<WorkflowConfigVo> jsonPage = new JsonPage<>(page.getCurrent(), page.getSize(), page.getTotal(), collect);
        return R.ok().setData(jsonPage);
    }

    /**
     * 添加
     * @param workflowConfig
     * @return
     */
    @ApiOperation(value = "添加信息", notes = "根据workflowConfig对象添加信息")
    @ApiImplicitParam(name = "workflowConfig", value = "详细实体workflowConfig", required = true, dataType = "WorkflowConfigDto")
    @PostMapping()
    public R saveWorkflowConfig(@RequestBody @Validated({ValidationGroups.Insert.class}) WorkflowConfigDto workflowConfig) {
        workflowConfigService.saveWorkflowConfig(workflowConfig);
        return R.ok();
    }

    /**
     * 修改
     * @param workflowConfig
     * @return
     */
    @ApiOperation(value = "修改信息", notes = "根据url的id来指定修改对象，并根据传过来的信息来修改详细信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path"),
            @ApiImplicitParam(name = "workflowConfig", value = "详细实体workflowConfig", required = true, dataType = "WorkflowConfigDto")
    })
    @PutMapping("/{id}")
    public R updateWorkflowConfig(@PathVariable String id, @RequestBody @Validated({ValidationGroups.Update.class}) WorkflowConfigDto workflowConfig) {
        workflowConfigService.updateWorkflowConfig(workflowConfig);
        return R.ok();
    }

    /**
     * 删除
     * @param id
     * @return
     */
    @ApiOperation(value = "删除", notes = "根据url的id来指定删除对象")
    @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path")
    @DeleteMapping("/{id}")
    public R deleteWorkflowConfigById(@PathVariable String id) {
        workflowConfigService.deleteWorkflowConfigById(id);
        return R.ok();
    }
}
