package cn.datax.service.data.market.api.call.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.R;
import cn.datax.service.data.market.api.call.service.ApiHeaderService;
import cn.datax.service.data.market.api.vo.ApiHeader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ApiHeaderController extends BaseController {

    @Autowired
    private ApiHeaderService apiHeaderService;

    @GetMapping(value = "/{id}/header")
    public R getApiHeader(@PathVariable String id){
        ApiHeader apiHeader = apiHeaderService.getApiHeader(id);
        return R.ok().setData(apiHeader);
    }
}
