/**
 * @param img 压缩图片
 * @param width：压缩后宽度
 * @param height：压缩后高度
 * @param rate：压缩比率,0~1，越小压缩比率越大
 * @returns {string} 返回base64
 */
export function compressImg(img, width, height, rate) {
  const canvas = document.createElement('canvas')
  const ctx = canvas.getContext('2d')
  canvas.width = width
  canvas.height = height
  ctx.drawImage(img, 0, 0, img.naturalWidth, img.naturalHeight, 0, 0, width, height)
  return canvas.toDataURL('image/png', rate)
}
