package cn.datax.service.system.api.feign;

import cn.datax.common.core.R;
import cn.datax.service.system.api.feign.factory.UserServiceFeignFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@FeignClient(contextId = "userServiceFeign", value = "datax-service-system", fallbackFactory = UserServiceFeignFallbackFactory.class)
public interface UserServiceFeign {

    @GetMapping("/inner/login/username/{username}")
    R loginByUsername(@PathVariable("username") String username);
}
