package cn.datax.common.log.event;

import cn.datax.service.system.api.dto.LogDto;
import cn.datax.service.system.api.feign.LogServiceFeign;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

/**
 * 异步监听日志事件
 *
 * @author yuwei
 * @since 2019/10/30
 */
@Slf4j
public class LogListener {

    @Autowired
    private LogServiceFeign logServiceFeign;

    @EventListener(LogEvent.class)
    public void saveSysLog(LogEvent event) {
        LogDto logDto = (LogDto) event.getSource();
        log.info("日志{}", logDto);
        logServiceFeign.saveLog(logDto);
    }
}
