const ss = sessionStorage

const storage = {
  ss: {
    get (key) {
      try {
        return JSON.parse(ss.getItem(key))
      } catch (e) {
        return undefined
      }
    },
    set (key, value) {
      ss.setItem(key, JSON.stringify(value))
    },
    remove (key) {
      ss.removeItem(key)
    },
    clear () {
      ss.clear()
    }
  }
}

export default storage
