package cn.datax.service.system.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.R;
import cn.datax.service.system.api.dto.LogDto;
import cn.datax.service.system.api.entity.LogEntity;
import cn.datax.service.system.service.LogService;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2019-09-04
 */
@Api(value="系统管理接口", tags = {"系统管理"})
@RestController
@RequestMapping("/logs")
public class LogController extends BaseController {

    @Autowired
    private LogService logService;

    @ApiOperation(value = "创建日志", notes = "根据log对象创建日志")
    @ApiImplicitParam(name = "log", value = "日志详细实体log", required = true, dataType = "logDto")
    @PostMapping()
    public R saveLog(@RequestBody LogDto log) {
        logService.saveLog(log);
        return R.ok();
    }

    @ApiOperation(value = "日志分页查询", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页码", required = true, dataType = "int", example = "1"),
            @ApiImplicitParam(name = "pageSize", value = "分页条数", required = true, dataType = "int", example = "20"),
            @ApiImplicitParam(name = "log", value = "日志详细实体log", required = false, dataTypeClass = LogDto.class)
    })
    @GetMapping("/page")
    public R getPostPage(@RequestParam(value="pageNum", defaultValue="1") Integer pageNum,
                         @RequestParam(value="pageSize", defaultValue="20") Integer pageSize,
                         LogDto log) {
        QueryWrapper<LogEntity> queryWrapper = Wrappers.emptyWrapper();
        queryWrapper.like(StrUtil.isNotBlank(log.getTitle()), "title", log.getTitle());
        IPage<LogEntity> page = logService.page(new Page<>(pageNum, pageSize), queryWrapper);
        return R.ok().setData(page);
    }
}
