package cn.datax.auth;

import cn.datax.common.mybatis.annotation.EnableDataMybatis;
import cn.datax.common.redis.annotation.EnableDataRedis;
import cn.datax.common.security.annotation.EnableDataServerProtect;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.client.SpringCloudApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;

@EnableDataServerProtect
@EnableDataMybatis
@EnableDataRedis
@EnableFeignClients(basePackages = {"cn.datax.service.system.api.feign"})
@SpringCloudApplication
public class DataxAuthApplication {

    public static void main(String[] args) {
        SpringApplication.run(DataxAuthApplication.class, args);
    }

}
