package cn.datax.service.data.quality.schedule.rules;

/**
 * 准确性核查
 * 核查项:长度
 * select sum(case when length(column) > 15 then 1 else 0 end), count(*) from table;
 */
public class AccuracyLlengthRule implements RuleItem {

    @Override
    public String parse(String table, String column) {
        final StringBuilder builder = new StringBuilder();
        builder.append("SELECT SUM(CASE WHEN LENGTH(").append(column).append(") > 15 THEN 1 ELSE 0 END), COUNT(*) FROM ").append(table);
        return builder.toString();
    }

    @Override
    public String code() {
        return "accuracy_key_length";
    }
}
