package cn.datax.service.data.quality.schedule.rules;

/**
 * 一致性核查
 * 核查项:字典
 * select sum(case when column not in ('0', '1') then 1 else 0 end), count(*) from table;
 */
public class ConsistentRule implements RuleItem {

    @Override
    public String parse(String table, String column) {
        final StringBuilder builder = new StringBuilder();
        builder.append("SELECT SUM(CASE WHEN ").append(column).append(" NOT IN ('0', '1') THEN 1 ELSE 0 END), COUNT(*) FROM ").append(table);
        return builder.toString();
    }

    @Override
    public String code() {
        return "consistent_key";
    }
}
