package cn.datax.service.data.quality.schedule.rules;

/**
 * 唯一性核查
 * 核查项:主键
 * select count(distinct id), count(*) from table;
 */
public class UniqueRule implements RuleItem {

    @Override
    public String parse(String table, String column) {
        final StringBuilder builder = new StringBuilder();
        builder.append("SELECT totalCount-count AS errorCount, totalCount FROM (");
        builder.append("SELECT COUNT(DISTINCT ").append(column).append(") AS count, COUNT(*) AS totalCount FROM ").append(table);
        builder.append(") AS TEMP");
        return builder.toString();
    }

    @Override
    public String code() {
        return "unique_key";
    }
}
