package cn.datax.service.data.factory.api.feign.fallback;

import cn.datax.service.data.factory.api.entity.DataSourceEntity;
import cn.datax.service.data.factory.api.feign.DataSourceServiceFeign;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class DataSourceServiceFeignFallbackImpl implements DataSourceServiceFeign {

    @Setter
    private Throwable cause;

    @Override
    public DataSourceEntity getDataSourceById(String id) {
        log.error("feign 调用{}出错", id, cause);
        return null;
    }

    @Override
    public void updateDataSourceSyncById(String id) {
        log.error("feign 调用{}出错", id, cause);
    }
}
