package cn.datax.common.redis.annotation;

import java.lang.annotation.*;

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RedisCacheAop {

    // 缓存名
    String cacheName() default "";
    // 过期时间(秒) time要大于0 如果time小于等于0 将设置无限期
    long expire() default -1;
    // 缓存反序列化获取的对象
    Class clazz() default Object.class;
    // 序列化后的对象是否是数组 比如 List<Object>
    boolean isArray() default false;
}
