package cn.datax.service.data.market.data.masking.factory;

import cn.datax.service.data.market.api.enums.AlgorithmCrypto;
import cn.datax.service.data.market.data.masking.factory.crypto.AlgorithmRegistry;
import cn.datax.service.data.market.data.masking.factory.crypto.Crypto;

public class AlgorithmFactory extends AbstractFactory {

    private static final AlgorithmRegistry ALGORITHM_REGISTRY = new AlgorithmRegistry();

    @Override
    public Crypto getAlgorithm(Integer type) {
        AlgorithmCrypto crypto = AlgorithmCrypto.getAlgorithmCrypto(type);
        return ALGORITHM_REGISTRY.getAlgorithm(crypto);
    }

    @Override
    public Crypto getRegex(Integer type) {
        return null;
    }
}
