package cn.datax.auth;

import cn.datax.common.mybatis.annotation.EnableDataMybatis;
import cn.datax.common.redis.annotation.EnableDataRedis;
import cn.datax.common.security.annotation.EnableDataAuthExceptionHandler;
import cn.datax.common.security.annotation.EnableDataServerProtect;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;

@EnableDiscoveryClient
@EnableCircuitBreaker
@EnableDataAuthExceptionHandler
@EnableDataServerProtect
@EnableDataMybatis
@EnableDataRedis
@EnableFeignClients
@ComponentScan({"cn.datax"})
@SpringBootApplication
public class DataxAuthApplication {

    public static void main(String[] args) {
        SpringApplication.run(DataxAuthApplication.class, args);
    }

}
