package cn.datax.service.system;

import cn.datax.common.log.annotation.EnableDataLog;
import cn.datax.common.mybatis.annotation.EnableDataMybatis;
import cn.datax.common.redis.annotation.EnableDataRedis;
import cn.datax.common.security.annotation.EnableDataAuthExceptionHandler;
import cn.datax.common.security.annotation.EnableDataServerProtect;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;

@EnableDataAuthExceptionHandler
@EnableDataServerProtect
@EnableDataMybatis
@EnableDataRedis
@EnableDataLog
@EnableDiscoveryClient
@EnableCircuitBreaker
@EnableFeignClients
@ComponentScan({"cn.datax"})
@SpringBootApplication
public class DataxSystemApplication {

    public static void main(String[] args) {
        SpringApplication.run(DataxSystemApplication.class);
    }

}
