package cn.datax.service.workflow.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.R;
import cn.datax.service.workflow.api.query.FlowTaskQuery;
import cn.datax.service.workflow.service.FlowTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = {"流程任务"})
@RestController
@RequestMapping("/tasks")
public class FlowTaskController extends BaseController {

    @Autowired
    private FlowTaskService flowTaskService;

    @ApiOperation(value = "分页查询代办任务")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "flowTaskQuery", value = "查询实体flowTaskQuery", required = true, dataTypeClass = FlowTaskQuery.class)
    })
    @GetMapping("/pageTodo")
    public R pageTodo(FlowTaskQuery flowTaskQuery) {
        flowTaskService.pageTodo(flowTaskQuery);
        return R.ok();
    }

    @ApiOperation(value = "分页查询已办任务")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "flowTaskQuery", value = "查询实体flowTaskQuery", required = true, dataTypeClass = FlowTaskQuery.class)
    })
    @GetMapping("/pageDone")
    public R pageDone(FlowTaskQuery flowTaskQuery) {
        flowTaskService.pageDone(flowTaskQuery);
        return R.ok();
    }
}
