package cn.datax.service.system.dao;

import cn.datax.service.system.api.entity.RoleMenuEntity;
import cn.datax.common.base.BaseDao;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author yuwei
 * @since 2019-09-11
 */
@Mapper
public interface RoleMenuDao extends BaseDao<RoleMenuEntity> {

    void insertBatch(List<RoleMenuEntity> list);

    @Delete("delete from sys_role_menu where role_id = #{id}")
    void deleteByRoleId(String id);

    @Delete("<script>" +
            "delete from sys_role_menu where role_id in <foreach collection='list' item='id' open='(' separator=',' close=')'>#{id}</foreach>" +
            "</script>")
    void deleteByRoleIds(List<String> ids);
}
