package cn.datax.service.data.factory.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.R;
import cn.datax.common.security.annotation.DataInner;
import cn.datax.service.data.factory.api.vo.DataSourceVo;
import cn.datax.service.data.factory.service.DataSourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/inner")
public class InnerController extends BaseController {

    @Autowired
    private DataSourceService dataSourceService;

    @DataInner
    @GetMapping("/dataSource/{id}")
    public R getDataSourceById(@PathVariable String id) {
        DataSourceVo dataSourceVo = dataSourceService.getDataSourceById(id);
        return R.ok().setData(dataSourceVo);
    }
}
