package cn.datax.service.workflow.service.impl;

import cn.datax.common.utils.SecurityUtil;
import cn.datax.service.workflow.api.enums.VariablesEnum;
import cn.datax.service.workflow.api.query.FlowTaskQuery;
import cn.datax.service.workflow.api.vo.FlowHistTaskVo;
import cn.datax.service.workflow.api.vo.FlowTaskVo;
import cn.datax.service.workflow.service.FlowTaskService;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.flowable.engine.HistoryService;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class FlowTaskServiceImpl implements FlowTaskService {

    @Autowired
    private TaskService taskService;

    @Autowired
    private HistoryService historyService;

    @Override
    public Page<FlowTaskVo> pageTodo(FlowTaskQuery flowTaskQuery) {
        TaskQuery taskQuery = taskService.createTaskQuery();
        taskQuery.taskCandidateOrAssigned(SecurityUtil.getUserId()).taskCandidateGroupIn(SecurityUtil.getUserRoleIds());
        if(StrUtil.isNotBlank(flowTaskQuery.getBusinessKey())){
            taskQuery.processInstanceBusinessKey(flowTaskQuery.getBusinessKey());
        }
        if(StrUtil.isNotBlank(flowTaskQuery.getBusinessType())){
            taskQuery.processVariableValueEquals(VariablesEnum.businessType.toString(), flowTaskQuery.getBusinessType());
        }
        if(StrUtil.isNotBlank(flowTaskQuery.getBusinessName())){
            taskQuery.processVariableValueLike(VariablesEnum.businessName.toString(), flowTaskQuery.getBusinessName());
        }
        List<Task> taskList = taskQuery.includeProcessVariables()
                .orderByTaskPriority().desc()
                .orderByTaskCreateTime().desc()
                .listPage((flowTaskQuery.getPageNum() - 1) * flowTaskQuery.getPageSize(), flowTaskQuery.getPageSize());
        List<FlowTaskVo> list = new ArrayList<>();
        taskList.stream().forEach(task -> {
            FlowTaskVo flowTaskVo = new FlowTaskVo();
            BeanUtil.copyProperties(task, flowTaskVo, "variables");
            //放入流程参数
            flowTaskVo.setVariables(task.getProcessVariables());
            list.add(flowTaskVo);
        });
        long count = taskQuery.count();
        Page<FlowTaskVo> page = new Page<>(flowTaskQuery.getPageNum(), flowTaskQuery.getPageSize());
        page.setRecords(list);
        page.setTotal(count);
        return page;
    }

    @Override
    public Page<FlowHistTaskVo> pageDone(FlowTaskQuery flowTaskQuery) {
        HistoricTaskInstanceQuery historicTaskInstanceQuery = historyService.createHistoricTaskInstanceQuery();
        historicTaskInstanceQuery.taskAssignee(SecurityUtil.getUserId());
        if (StrUtil.isNotBlank(flowTaskQuery.getBusinessKey())) {
            historicTaskInstanceQuery.processInstanceBusinessKey(flowTaskQuery.getBusinessKey());
        }
        if (StrUtil.isNotBlank(flowTaskQuery.getBusinessName())) {
            historicTaskInstanceQuery.processVariableValueEquals(VariablesEnum.businessType.toString(), flowTaskQuery.getBusinessName());
        }
        if (StrUtil.isNotBlank(flowTaskQuery.getBusinessType())) {
            historicTaskInstanceQuery.processVariableValueLike(VariablesEnum.businessName.toString(), flowTaskQuery.getBusinessType());
        }
        List<HistoricTaskInstance> historicTaskInstanceList = historicTaskInstanceQuery.finished()
                .includeProcessVariables().orderByHistoricTaskInstanceEndTime().desc()
                .listPage((flowTaskQuery.getPageNum() - 1) * flowTaskQuery.getPageSize(), flowTaskQuery.getPageSize());
        List<FlowHistTaskVo> list = new ArrayList<>();
        historicTaskInstanceList.stream().forEach(task -> {
            FlowHistTaskVo flowHistTaskVo = new FlowHistTaskVo();
            BeanUtil.copyProperties(task, flowHistTaskVo, "variables");
            //放入流程参数
            flowHistTaskVo.setVariables(task.getProcessVariables());
            list.add(flowHistTaskVo);
        });
        long count = historicTaskInstanceQuery.count();
        Page<FlowHistTaskVo> page = new Page<>(flowTaskQuery.getPageNum(), flowTaskQuery.getPageSize());
        page.setRecords(list);
        page.setTotal(count);
        return page;
    }
}
