package cn.datax.service.system.controller;

import cn.datax.common.core.R;
import cn.datax.common.validate.ValidateGroupForSave;
import cn.datax.common.validate.ValidateGroupForUpdate;
import cn.datax.service.system.api.dto.MenuDto;
import cn.datax.service.system.service.MenuService;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2019-09-11
 */
@RestController
@RequestMapping("/menu")
public class MenuController extends BaseController {

    @Autowired
    private MenuService menuService;

    @GetMapping("/{id}")
    public R getMenuById(@PathVariable String id) {
        return R.ok().setData(menuService.getById(id));
    }

    @GetMapping("/list")
    public R getMenuList() {
        return R.ok().setData(menuService.list(Wrappers.emptyWrapper()));
    }

    @PostMapping()
    public R saveMenu(@RequestBody @Validated({ValidateGroupForSave.class}) MenuDto menu) {
        menuService.saveMenu(menu);
        return R.ok();
    }

    @PutMapping()
    public R updateMenu(@RequestBody @Validated({ValidateGroupForUpdate.class}) MenuDto menu) {
        menuService.updateMenu(menu);
        return R.ok();
    }

    @DeleteMapping("/{id}")
    public R deleteMenu(@PathVariable String id) {
        menuService.deleteMenuById(id);
        return R.ok();
    }

}

