package cn.datax.service.system.controller;

import cn.datax.common.core.R;
import cn.datax.common.validate.ValidateGroupForSave;
import cn.datax.common.validate.ValidateGroupForUpdate;
import cn.datax.service.system.api.dto.PostDto;
import cn.datax.service.system.api.entity.PostEntity;
import cn.datax.service.system.service.PostService;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2019-09-11
 */
@RestController
@RequestMapping("/post")
public class PostController extends BaseController {

    @Autowired
    private PostService postService;

    @GetMapping("/{id}")
    public R getPostById(@PathVariable String id) {
        return R.ok().setData(postService.getById(id));
    }

    @GetMapping("/page")
    public R getPostPage(Page page, PostEntity post) {
        return R.ok().setData(postService.page(page, Wrappers.query(post)));
    }

    @PostMapping()
    public R savePost(@RequestBody @Validated({ValidateGroupForSave.class}) PostDto post) {
        postService.savePost(post);
        return R.ok();
    }

    @PutMapping()
    public R updatePost(@RequestBody @Validated({ValidateGroupForUpdate.class}) PostDto post) {
        postService.updatePost(post);
        return R.ok();
    }

    @DeleteMapping("/{id}")
    public R deletePost(@PathVariable String id) {
        postService.deletePostById(id);
        return R.ok();
    }

}

