package cn.datax.service.quartz.config;

import cn.datax.service.quartz.quartz.utils.ScheduleUtil;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import lombok.AllArgsConstructor;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.autoconfigure.quartz.QuartzDataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.AdaptableJobFactory;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;

@Configuration
@AllArgsConstructor
public class SchedulerConfig {

    private final DataSource dataSource;

    @Bean
    public SchedulerFactoryBean schedulerFactoryBean() {
        SchedulerFactoryBean factory = new SchedulerFactoryBean();
        // 手动从多数据源中获取 quartz数据源
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource) dataSource;
        DataSource quartz = ds.getDataSource("quartz");
        factory.setDataSource(quartz);
        return factory;
    }

//    /**
//     * 该类主要是为了把 job 对象的注入到 spring 中
//     */
//    @Component("quartzJobFactory")
//    public static class QuartzJobFactory extends AdaptableJobFactory {
//        //这个对象可以通过 ApplicationContext.getAutowireCapableBeanFactory()获取
//        private final AutowireCapableBeanFactory capableBeanFactory;
//
//        public QuartzJobFactory(AutowireCapableBeanFactory capableBeanFactory) {
//            this.capableBeanFactory = capableBeanFactory;
//        }
//        /**
//         * Job 对象的实例化过程是在Quartz中进行的，通过重写此方法 把job 实例注入到spring容器中
//         */
//        @Override
//        protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
//            //调用父类的方法
//            Object jobInstance = super.createJobInstance(bundle);
//            //注入到spring容器
//            capableBeanFactory.autowireBean(jobInstance);
//            return jobInstance;
//        }
//    }

//    /**
//     * 注入scheduler到spring
//     * @param quartzJobFactory
//     * @return Scheduler
//     * @throws Exception
//     */
//    @Bean(name = "scheduler")
//    public Scheduler scheduler(QuartzJobFactory quartzJobFactory) throws Exception {
//        SchedulerFactoryBean factoryBean = new SchedulerFactoryBean();
//        factoryBean.setJobFactory(quartzJobFactory);
//        factoryBean.setDataSource(quartzDataSource());
//        factoryBean.afterPropertiesSet();
//        Scheduler scheduler = factoryBean.getScheduler();
//        scheduler.start();
//        // 设置ScheduleUtil的定时处理对象
//        ScheduleUtil.setScheduler(scheduler);
//        return scheduler;
//    }

    @Bean(name = "scheduler")
    public Scheduler scheduler() throws SchedulerException {
        Scheduler scheduler = schedulerFactoryBean().getScheduler();
        scheduler.start();
        // 设置ScheduleUtil的定时处理对象
        ScheduleUtil.setScheduler(scheduler);
        return scheduler;
    }
}
