package cn.datax.auth.translator;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

import java.io.IOException;

public class DataOauthExceptionSerializer extends StdSerializer<DataOauthException> {

    public DataOauthExceptionSerializer() {
        super(DataOauthException.class);
    }

    @Override
    public void serialize(DataOauthException value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField("code", value.getHttpErrorCode());
        gen.writeStringField("msg", value.getMessage());
        gen.writeBooleanField("success", false);
        gen.writeNumberField("timestamp", System.currentTimeMillis());
        gen.writeEndObject();
    }
}
