package com.tbyf.license;

import com.alibaba.fastjson2.JSON;
import global.namespace.fun.io.bios.BIOS;
import global.namespace.truelicense.api.License;
import global.namespace.truelicense.api.LicenseManagementContext;
import global.namespace.truelicense.api.LicenseManagementException;
import global.namespace.truelicense.api.VendorLicenseManager;
import global.namespace.truelicense.core.passwd.ObfuscatedPasswordProtection;
import global.namespace.truelicense.obfuscate.ObfuscatedString;
import global.namespace.truelicense.v4.V4;

import javax.security.auth.x500.X500Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LicenseGenerator {

    private static final String SUBJECT = "HIP";
    private static final String DISTINGUISHED_NAME = "CN=TBYF";
    private static final String KEY_STORE_FILE = "private.ks";

    private static final LicenseManagementContext _managementContext = V4
            .builder()
            .initialization(license -> {
                license.setSubject(SUBJECT);
                license.setIssuer(new X500Principal(DISTINGUISHED_NAME));
            })
            .subject(SUBJECT)
            .build();

    volatile VendorLicenseManager _manager;

    public VendorLicenseManager manager() {
        VendorLicenseManager m = this._manager;
        return null != m ? m : (this._manager = newManager());
    }

    private VendorLicenseManager newManager() {

        return _managementContext
                .vendor()
                .encryption()
                .protection(protection(new long[]{0xa62021d62ef7e061L, 0xd32b4d88c40291afL}))   /* "P@ssw0rd" */
                .up()
                .authentication()
                .alias("standard")
                .loadFromResource(KEY_STORE_FILE)
                .storeProtection(protection(new long[]{0x1bc1838eb8e7378cL, 0x88679932d1e8bedcL, 0x6e59d724487b1939L})) /* "Esb@123$%^" */
                .up()
                .build();
    }

    private static ObfuscatedPasswordProtection protection(long[] longs) {
        return new ObfuscatedPasswordProtection(new ObfuscatedString(longs));
    }

    public void generate(LicenseParams params) throws LicenseManagementException {
        VendorLicenseManager manager = manager();
        License license = manager.parameters().licenseFactory().license();
        license.setConsumerAmount(params.getAmount()); // 消费者数量
        license.setConsumerType(params.getType()); // business-企业 personally-个人 project-项目
        license.setHolder(new X500Principal(params.getHolder())); // 许可证持有者的唯一标识
        license.setIssuer(new X500Principal(DISTINGUISHED_NAME)); // 许可证颁发者的唯一标识
        license.setInfo(params.getInfo()); // 面向用户的说明文本
        license.setIssued(new Date()); // 许可证颁发日期
        license.setNotBefore(params.getStartDate()); // 许可证生效日期
        license.setNotAfter(new Date(params.getStartDate().getTime() + (long) params.getValidity() * 24 * 60 * 60 * 1000)); // 许可证失效日期
        license.setSubject(params.getAppName() + "-" + params.getVersion()); // 许可证管理的目标（如应用名称和版本范围 "MyApp 1.X"）
        Map<String,Object> extra = new HashMap<>();
        extra.put("mac",params.getMac());
        extra.put("urls",params.getUrls());
        license.setExtra(JSON.toJSONString(extra)); // 私有数据，如MAC地址
        manager.generateKeyFrom(license)
                .saveTo(BIOS.file(params.getLicensePath()));
    }

}
