package com.tbyf.license;

import global.namespace.fun.io.bios.BIOS;
import global.namespace.truelicense.api.License;
import global.namespace.truelicense.api.LicenseInitialization;
import global.namespace.truelicense.api.LicenseManagementContext;
import global.namespace.truelicense.api.LicenseManagementException;
import global.namespace.truelicense.api.VendorLicenseManager;
import global.namespace.truelicense.core.passwd.ObfuscatedPasswordProtection;
import global.namespace.truelicense.obfuscate.ObfuscatedString;
import global.namespace.truelicense.v4.V4;

import javax.security.auth.x500.X500Principal;

public class LicenseManager {

    private static final String SUBJECT = "HIP";
    private static final String DISTINGUISHED_NAME = "CN=TBYF HIP";
    private static final String KEY_STORE_FILE = "private.ks";

    static LicenseInitialization licenseInitialization;

    private static final LicenseManagementContext _managementContext = V4
            .builder()
            .initialization(license -> {
                license.setSubject(SUBJECT);
                license.setIssuer(new X500Principal(DISTINGUISHED_NAME));
            })
            .subject(SUBJECT)
            .build();

    volatile VendorLicenseManager _manager;

    public VendorLicenseManager manager() {
        VendorLicenseManager m = this._manager;
        return null != m ? m : (this._manager = newManager());
    }

    private VendorLicenseManager newManager() {

        return _managementContext
                .vendor()
                .encryption()
                    .protection(protection(new long[]{0xa62021d62ef7e061L, 0xd32b4d88c40291afL}))   /* "P@ssw0rd" */
                    .up()
                .authentication()
                    .alias("standard")
                    .loadFromResource(KEY_STORE_FILE)
                    .storeProtection(protection(new long[]{0x1bc1838eb8e7378cL, 0x88679932d1e8bedcL, 0x6e59d724487b1939L})) /* "Esb@123$%^" */
                    .up()
                .build();
    }

    private static ObfuscatedPasswordProtection protection(long[] longs) {
        return new ObfuscatedPasswordProtection(new ObfuscatedString(longs));
    }

    public void generate(LicenseParams params) throws LicenseManagementException {
        VendorLicenseManager manager = manager();
        License license = manager.parameters().licenseFactory().license();
        license.setNotBefore(params.getStartDate());
        license.setNotAfter(params.getExpirationDate());
        license.setExtra(params.getMAC());
        manager.generateKeyFrom(license)
                .saveTo(BIOS.file(params.getFilename()));
    }

}
