package com.tbyf.license;

import lombok.Builder;
import lombok.Getter;

import java.util.Calendar;
import java.util.Date;

@Builder
public class LicenseParams {

    @Getter
    private String filename;

    private Date startDate;

    // 有效天数
    private int validity;

    private Date expirationDate;

    @Getter
    private String MAC; // MAC硬件地址

    public Date getExpirationDate() {
        Date ed = this.expirationDate;
        return null != ed ? ed : calculateExpirationDate();
    }

    public Date getStartDate() {
        Date sd = this.startDate;
        return null != sd ? sd : new Date();
    }

    private Date calculateExpirationDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(getStartDate());
        calendar.add(Calendar.DAY_OF_YEAR, this.validity);
        return calendar.getTime();
    }
}
