package com.tbyf.license;

import lombok.Data;
import lombok.Getter;

import java.util.Date;

@Data
public class LicenseParams {

    @Getter
    private String licensePath;

    /**
     * 开始日期
     */
    private Date startDate;

    /**
     * license有效天数
     */
    private int validity;

    /**
     * 授权数量
     */
    private int amount = 1;

    /**
     * 授权类型 business-企业 personally-个人 project-项目
     */
    private String type = "business";

    /**
     * 授权信息
     */
    private String info = "tbyf hip license";

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 授权使用的版本
     */
    private String version;

    /**
     * 授权使用的MAC地址, *为所有mac都支持
     */
    private String mac = "*";

    /**
     * 需要限制的url, *为所有url都支持
     */
    private String urls;
}
