package com.tbyf.license;

import global.namespace.truelicense.api.LicenseManagementException;
import org.junit.jupiter.api.Test;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class LicenseGeneratorTest {

    @Test
    void generate() throws LicenseManagementException, ParseException {
        LicenseGenerator licenseGenerator = new LicenseGenerator();
        licenseGenerator.generate(
                LicenseParams.builder()
                        .licensePath("dev.lic")
                        .validity(3)
//                        .expirationDate(toDate("2024-01-11 15:12:00"))
                        .MAC("14-75-5B-E3-DE-1F")
                        .build());
    }

    Date toDate(String dateStr) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.parse(dateStr);
    }
}