package com.tbyf.license;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import global.namespace.fun.io.api.NoContentException;
import global.namespace.truelicense.api.LicenseManagementException;
import global.namespace.truelicense.api.LicenseValidationException;
import global.namespace.truelicense.obfuscate.ObfuscatedString;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LicenseValidationFilter extends OncePerRequestFilter {

    private LicenseManager licenseManager;

    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    private static final List<String> whiteList = new ArrayList<>();


    // /license/install
    private final static String URL1 = new ObfuscatedString(new long[]{0x3c29fe15c616ba98L, 0xf20dd79db1dad670L, 0x89664e7a93dd88d0L}).toString();

    // /license/uninstall
    private final static String URL2 = new ObfuscatedString(new long[]{0xc26bb1827bac0fbfL, 0xcd9c362b393e579fL, 0xe69b7905e04224deL, 0x44e7c7c44c3b3c99L}).toString();

    static {
        whiteList.add(URL1);
        whiteList.add(URL2);
    }

    // Invalid License
    private final static String INVALID_LICENSE =
            new ObfuscatedString(new long[]{
                    0xf028f58c58a58b70L, 0x8e3687628cabf715L, 0x1d7b18d3be15ee3cL,
                    0x6484235954092864L, 0x1d0c5795e106b625L, 0x85bd4fc5f74c1953L,
                    0xbd8ecfc20bd71d2L, 0x43a6f39da2c77092L, 0xdb66a1baf052acdL,
                    0x5289ce404edb39b2L}).toString();

    // No License
    private final static String NO_LICENSE =
            new ObfuscatedString(new long[]{
                    0xc8eb6c067584a44fL, 0x3b927f424d2f8b3dL, 0x63b037cacbc18631L,
                    0xea641540f5303384L, 0xf74c5ed8383e8a2aL, 0x58e83b8ba2f4d29dL,
                    0xa87739551ba09b21L, 0x388b360692cb587L, 0x9a270e40ae793a05L}).toString();

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (isInWhiteList(request)) {
            filterChain.doFilter(request, response);
            return;
        }

        try {
            this.licenseManager.verify();
            filterChain.doFilter(request, response);
        }
        catch (LicenseValidationException e) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            response.setContentType(MediaType.APPLICATION_JSON_VALUE);
            response.getWriter().write(INVALID_LICENSE);
        }
        catch (LicenseManagementException e) {
            if (e.getCause() instanceof NoContentException) {
                response.setStatus(HttpStatus.FORBIDDEN.value());
                response.setContentType(MediaType.APPLICATION_JSON_VALUE);
                response.getWriter().write(NO_LICENSE);
            }
        }
        catch (Exception e) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            response.setContentType(MediaType.TEXT_PLAIN_VALUE);
            response.getWriter().write("Internal Error");
        }
    }

    private boolean isInWhiteList(HttpServletRequest request) {
        for (String uri : whiteList) {
            if (this.pathMatcher.match(uri, request.getRequestURI())) {
                return true;
            }
        }
        return false;
    }

}
