package com.tbyf.license.autoconfigure;

import com.tbyf.license.Constants;
import com.tbyf.license.LicenseManager;
import lombok.Setter;
import org.springframework.http.HttpStatus;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;


/**
 * 许可证安装Servlet
 * 用于接收客户端上传的许可证文件（.lic）并进行安装验证
 */
@Setter
public class LicenseInstallationServlet extends HttpServlet {

    /**
     * 许可证管理器，用于安装和验证许可证
     */
    private LicenseManager licenseManager;

    private LicenseProperties properties;

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        // 通过 multipart/form-data 接收名为 license 的许可证文件
        Part filePart = req.getPart("license");
        try (InputStream is = filePart.getInputStream()) {
            Path dest = Paths.get(properties.getLocation(), Constants.LICENSE_FILE_NAME).toAbsolutePath().normalize();
            // 将上传的许可证文件保存到指定目录（由 LicenseProperties 配置）。
            Files.copy(is, dest, StandardCopyOption.REPLACE_EXISTING);
            // 激活许可证。
            this.licenseManager.install(dest.toString());
            resp.setStatus(HttpStatus.OK.value());
            resp.setContentType(Constants.TEXT_PLAIN_MEDIA_TYPE);
            resp.getWriter().write("200");
        }
        catch (Exception e) {
            resp.setStatus(HttpStatus.BAD_REQUEST.value());
            resp.setContentType(Constants.TEXT_PLAIN_MEDIA_TYPE);
            resp.getWriter().write("400");
        }
    }

}
