package com.tbyf.license.autoconfigure;

import com.tbyf.license.LicenseManager;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;

import javax.servlet.MultipartConfigElement;

@EnableConfigurationProperties(LicenseProperties.class)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@AutoConfiguration(after = {DispatcherServletAutoConfiguration.class})
// @ConditionalOnProperty(prefix = "license", name = "enabled", havingValue = "true")
public class LicenseAutoConfiguration {

    @Bean
    public LicenseManager licenseManager() {
        return new LicenseManager();
    }

    @Bean
    public FilterRegistrationBean<LicenseValidationFilter> licenseFilter() {
        FilterRegistrationBean<LicenseValidationFilter> registrationBean = new FilterRegistrationBean<>();
        LicenseValidationFilter filter = new LicenseValidationFilter();
        filter.setLicenseManager(licenseManager());
        registrationBean.setFilter(filter);
        registrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE);
        return registrationBean;
    }

    @Bean
    public ServletRegistrationBean<LicenseInstallationServlet> licenseServlet(LicenseProperties licenseProperties) {
        LicenseInstallationServlet servlet = new LicenseInstallationServlet();
        servlet.setLicenseManager(licenseManager());
        servlet.setProperties(licenseProperties);
        ServletRegistrationBean<LicenseInstallationServlet> registrationBean = new ServletRegistrationBean<>(servlet, "/license/install");
        registrationBean.setMultipartConfig(new MultipartConfigElement("", 1024 * 1024, 1024 * 1024, 1024 * 1024));
        return registrationBean;
    }
}
