package com.tbyf.license.autoconfigure;

import com.tbyf.license.Constants;
import com.tbyf.license.LicenseManager;
import lombok.Setter;
import org.springframework.http.HttpStatus;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;


public class LicenseInstallationServlet extends HttpServlet {


    @Setter
    private LicenseManager licenseManager;

    @Setter
    private LicenseProperties properties;

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Part filePart = req.getPart("license");
        try (InputStream is = filePart.getInputStream()) {
            Path dest = Paths.get(properties.getLocation(), Constants.LICENSE_FILE_NAME).toAbsolutePath().normalize();
            Files.copy(is, dest, StandardCopyOption.REPLACE_EXISTING);

            this.licenseManager.install(dest.toString());
            resp.setStatus(HttpStatus.OK.value());
            resp.setContentType(Constants.TEXT_PLAIN_MEDIA_TYPE);
            resp.getWriter().write("200");
        }
        catch (Exception e) {
            resp.setStatus(HttpStatus.BAD_REQUEST.value());
            resp.setContentType(Constants.TEXT_PLAIN_MEDIA_TYPE);
            resp.getWriter().write("400");
        }
    }

}
