package com.tbyf.license;

import global.namespace.fun.io.api.NoContentException;
import global.namespace.truelicense.api.LicenseManagementException;
import global.namespace.truelicense.api.LicenseValidationException;
import org.junit.jupiter.api.Test;

class LicenseManagerTest {

    @Test
    void uninstall() throws Exception {
        new LicenseManager().uninstall();
    }

    @Test
    void install() throws Exception {
        new LicenseManager().install("hip.lic");
    }

    @Test
    void getLicenseValidPeriod() throws LicenseManagementException {
        System.out.println(new LicenseManager().getLicenseValidPeriod());
    }

    @Test
    void verify() throws Exception {
        LicenseManager licenseManager = new LicenseManager();
        try {
            licenseManager.verify();
            System.out.println();
        }
        catch (LicenseValidationException e) {
            System.out.println("无效证书");
        }
        catch (LicenseManagementException e) {
            if (e.getCause() instanceof NoContentException) {
                System.out.println("证书未安装");
            }
            else {
                e.printStackTrace();
            }
        }
    }
}