package com.tbyf.license;

import global.namespace.fun.io.bios.BIOS;
import global.namespace.truelicense.api.ConsumerLicenseManager;
import global.namespace.truelicense.api.License;
import global.namespace.truelicense.api.LicenseManagementContext;
import global.namespace.truelicense.api.LicenseManagementException;
import global.namespace.truelicense.api.LicenseValidationException;
import global.namespace.truelicense.core.passwd.ObfuscatedPasswordProtection;
import global.namespace.truelicense.obfuscate.ObfuscatedString;
import global.namespace.truelicense.v4.V4;


public class LicenseManager {

    private static final String SUBJECT = "HIP";
    private static final String KEY_STORE_FILE = "public.ks";

    private static final LicenseManagementContext _managementContext = V4
            .builder()
            .validation(license -> verifyMAC(license.getExtra()))
            .subject(SUBJECT)
            .build();

    volatile ConsumerLicenseManager _manager;

    private static void verifyMAC(Object MAC) throws LicenseValidationException {
        if (MAC == null || !NetUtil.containsMAC(MAC.toString())) {
            throw new LicenseValidationException(Messages.message("Invalid License"));
        }
    }

    ConsumerLicenseManager manager() {
        ConsumerLicenseManager m = this._manager;
        return null != m ? m : (this._manager = newManager());
    }

    private ConsumerLicenseManager newManager() {
        return _managementContext
                .consumer()
                .encryption()
                    .protection(protection(new long[]{0x9d823a2b21bef869L, 0x4f4790eaa895d3d8L}))
                    .up()
                .authentication()
                    .alias("standard")
                    .loadFromResource(KEY_STORE_FILE)
                    .storeProtection(protection(new long[]{0x10111721aeba73dcL, 0x1aba2dc58b17fdbeL, 0x126b920ac6703949L}))
                    .up()
                .storeInUserPreferences(getClass())
                .build();
    }

    private static ObfuscatedPasswordProtection protection(long[] longs) {
        return new ObfuscatedPasswordProtection(new ObfuscatedString(longs));
    }

    public void verify() throws Exception {
        manager().verify();
    }

    public void install(String licensePath) throws Exception {
        manager().install(BIOS.file(licensePath));
    }

    public void uninstall() throws Exception {
        manager().uninstall();
    }

    public LicenseValidPeriod getLicenseValidPeriod() throws LicenseManagementException {
        License license = manager().load();
        LicenseValidPeriod period = new LicenseValidPeriod();
        period.setStartTime(license.getNotBefore());
        period.setExpirationTime(license.getNotAfter());
        return period;
    }
}
