package com.tbyf.license;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletAutoConfiguration;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;

import javax.servlet.MultipartConfigElement;

@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@AutoConfiguration(after = {DispatcherServletAutoConfiguration.class})
public class LicenseAutoConfiguration {

    @Bean
    public LicenseManager licenseManager() {
        return new LicenseManager();
    }

    @Bean
    public FilterRegistrationBean<LicenseValidationFilter> licenseFilter() {
        FilterRegistrationBean<LicenseValidationFilter> registrationBean = new FilterRegistrationBean<>();
        LicenseValidationFilter filter = new LicenseValidationFilter();
        filter.setLicenseManager(licenseManager());
        registrationBean.setFilter(filter);
        registrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE);
        return registrationBean;
    }

    @Bean
    public ServletRegistrationBean<LicenseInstallationServlet> licenseServlet() {
        LicenseInstallationServlet servlet = new LicenseInstallationServlet();
        servlet.setLicenseManager(licenseManager());
        ServletRegistrationBean<LicenseInstallationServlet> registrationBean = new ServletRegistrationBean<>(servlet, "/license/install");
        registrationBean.setMultipartConfig(new MultipartConfigElement("", 1024 * 1024, 1024 * 1024, 1024 * 1024));
        return registrationBean;
    }
}
