package com.tbyf.license;

import global.namespace.fun.io.api.NoContentException;
import global.namespace.truelicense.api.LicenseManagementException;
import global.namespace.truelicense.api.LicenseValidationException;
import global.namespace.truelicense.obfuscate.ObfuscatedString;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LicenseValidationFilter extends OncePerRequestFilter {

    private LicenseManager licenseManager;

    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    private static final List<String> whiteList = new ArrayList<>();


    // /license/install
    private final static String URL1 = new ObfuscatedString(new long[]{0x3c29fe15c616ba98L, 0xf20dd79db1dad670L, 0x89664e7a93dd88d0L}).toString();

    // /license/uninstall
    private final static String URL2 = new ObfuscatedString(new long[]{0xc26bb1827bac0fbfL, 0xcd9c362b393e579fL, 0xe69b7905e04224deL, 0x44e7c7c44c3b3c99L}).toString();

    static {
        whiteList.add(URL1);
        whiteList.add(URL2);
    }

    // Invalid License
    private final static String INVALID_LICENSE =
            new ObfuscatedString(new long[]{
                    0x49e5266592028869L, 0x9315b379de60a1beL, 0xe1fde0262ab5ed27L,
                    0xde54ce8a8e5d4e19L, 0x42880fae5dbb8a13L, 0x7dc34d7fb839ec0dL,
                    0x99a3515ef60c84a5L, 0xc708fcab8319dfb3L}).toString();

    // No License
    private final static String NO_LICENSE =
            new ObfuscatedString(new long[]{
                    0x8cb7df8f04d69f43L, 0xd616159bdf90a5eL, 0x508a735a1546f8bcL,
                    0x7925f6557e460d53L, 0x4667e92ce4bcef22L, 0x359b5eefb590ca78L,
                    0x239eba55236200f0L}).toString();

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (isInWhiteList(request)) {
            filterChain.doFilter(request, response);
            return;
        }

        try {
            this.licenseManager.verify();
            filterChain.doFilter(request, response);
        }
        catch (LicenseValidationException e) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            response.setContentType(MediaType.APPLICATION_JSON_VALUE);
            response.getWriter().write(INVALID_LICENSE);
        }
        catch (LicenseManagementException e) {
            if (e.getCause() instanceof NoContentException) {
                response.setStatus(HttpStatus.FORBIDDEN.value());
                response.setContentType(MediaType.APPLICATION_JSON_VALUE);
                response.getWriter().write(NO_LICENSE);
            }
        }
        catch (Exception e) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            response.setContentType(MediaType.TEXT_PLAIN_VALUE);
            response.getWriter().write("Internal Error");
        }
    }

    private boolean isInWhiteList(HttpServletRequest request) {
        for (String uri : whiteList) {
            if (this.pathMatcher.match(uri, request.getRequestURI())) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(ObfuscatedString.obfuscate("/license/uninstall"));
    }
}
