package com.tbyf.license;

import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
public class LicenseAutoConfiguration {

    @Bean
    public LicenseManager licenseManager() {
        return new LicenseManager();
    }

    @Bean
    public FilterRegistrationBean<LicenseValidationFilter> licenseFilter() {
        FilterRegistrationBean<LicenseValidationFilter> registrationBean = new FilterRegistrationBean<>();
        LicenseValidationFilter filter = new LicenseValidationFilter();
        filter.setLicenseManager(licenseManager());
        registrationBean.setFilter(filter);
        registrationBean.addUrlPatterns("/**");
        return registrationBean;
    }
}
