package com.tbyf.license;

import global.namespace.truelicense.obfuscate.ObfuscatedString;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class LicenseValidationFilter extends OncePerRequestFilter {

    private LicenseManager licenseManager;

    // Invalid License
    private final static String INVALID_LICENSE =
            new ObfuscatedString(new long[]{
                    0x49e5266592028869L, 0x9315b379de60a1beL, 0xe1fde0262ab5ed27L,
                    0xde54ce8a8e5d4e19L, 0x42880fae5dbb8a13L, 0x7dc34d7fb839ec0dL,
                    0x99a3515ef60c84a5L, 0xc708fcab8319dfb3L}).toString();

    // No License
    private final static String NO_LICENSE =
            new ObfuscatedString(new long[]{
                    0x8cb7df8f04d69f43L, 0xd616159bdf90a5eL, 0x508a735a1546f8bcL,
                    0x7925f6557e460d53L, 0x4667e92ce4bcef22L, 0x359b5eefb590ca78L,
                    0x239eba55236200f0L}).toString();

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            this.licenseManager.verify();
        }
        catch (Exception e) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            response.setContentType(MediaType.APPLICATION_JSON_VALUE);
            response.getWriter().write(INVALID_LICENSE);
        }
    }
}
