package com.tbyf.license;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class NetUtil {

    private static volatile Set<String> cache;

    public static boolean containsMAC(String MAC) {
        return getAllMACs().contains(MAC.toUpperCase());
    }

    private static Set<String> getAllMACs() {
        Set<String> allMACs = cache;
        if (allMACs != null && !allMACs.isEmpty()) {
            return allMACs;
        }
        return (cache = fetchAllMACs());
    }

    private static Set<String> fetchAllMACs() {
        try {
            Enumeration<NetworkInterface> ifcs = NetworkInterface.getNetworkInterfaces();
            Set<String> allMACs = new HashSet<>();
            while (ifcs.hasMoreElements()) {
                NetworkInterface ifc = ifcs.nextElement();

                byte[] macBytes = ifc.getHardwareAddress();
                String[] MAC = new String[6];
                if (macBytes != null && macBytes.length == 6) {
                    for (int i = 0; i < macBytes.length; i++) {
                        MAC[i] = String.format("%02x", macBytes[i]).toUpperCase();
                    }
                    allMACs.add(String.join("-", MAC));
                }
            }
            System.out.println("本地MAC地址为: " + allMACs);
            return allMACs;
        }
        catch (SocketException e) {
            return Collections.emptySet();
        }
    }
}
