package com.hy.example;

import com.tbyf.dataadapter.task.processor.Configuration;
import com.tbyf.dataadapter.task.processor.ProcessorContext;
import com.tbyf.dataadapter.task.processor.plugin.HeadProcessorExtension;

import java.util.UUID;

public class HP extends HeadProcessorExtension {

    protected int uuidLength;

    @Override
    public Object fetch(ProcessorContext processorContext) {
        return UUID.randomUUID().toString().substring(0, uuidLength);
    }

    @Override
    protected void doConfigure(Configuration configuration) {
        uuidLength = configuration.getInt("uuidL");
        if (uuidLength > 32 || uuidLength < 1) {
            throw new IllegalArgumentException("invalid uuidL " + uuidLength);
        }
    }
}
