package com.tbyf.oraclecdc;

import io.debezium.connector.oracle.OracleConnector;
import io.debezium.relational.history.FileDatabaseHistory;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class CdcProperties {

    private String host;
    private int port;
    private String dbname;
    private String user;
    private String password;
    private String offsetFileLocation;
    private String historyFileLocation;
    private String tables;
    private boolean autoEnableSupplementLogging = true;
    private int channelCapacity = 20000;

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDbname() {
        return dbname;
    }

    public void setDbname(String dbname) {
        this.dbname = dbname;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getChannelCapacity() {
        return channelCapacity;
    }

    public void setChannelCapacity(int channelCapacity) {
        this.channelCapacity = channelCapacity;
    }

    public String getOffsetFileLocation() {
        String offsetFileLocation = this.offsetFileLocation;
        if (offsetFileLocation == null) {
            offsetFileLocation = "cdc/offset/" + host + "_" + port + "/" + user + ".off";
        }
        return offsetFileLocation;
    }

    public void setOffsetFileLocation(String offsetFileLocation) {
        this.offsetFileLocation = offsetFileLocation;
    }

    public String getHistoryFileLocation() {
        String historyFileLocation = this.historyFileLocation;
        if (historyFileLocation == null) {
            historyFileLocation = "cdc/history/" + host + "_" + port + "/" + user + ".his";
        }
        return historyFileLocation;
    }

    public void setHistoryFileLocation(String historyFileLocation) {
        this.historyFileLocation = historyFileLocation;
    }

    public String getTables() {
        return tables;
    }

    public void setTables(String tables) {
        this.tables = tables;
    }

    public boolean isAutoEnableSupplementLogging() {
        return autoEnableSupplementLogging;
    }

    public void setAutoEnableSupplementLogging(boolean autoEnableSupplementLogging) {
        this.autoEnableSupplementLogging = autoEnableSupplementLogging;
    }

    public void validate() {
        // todo
    }

    public Properties asDebeziumProps() {
        Properties props = new Properties();
        props.putAll(Config.DEBEZIUM_PROPERTIES);

        props.setProperty("connector.class", OracleConnector.class.getName());
        props.setProperty("database.history", FileDatabaseHistory.class.getName());
        props.setProperty("database.history.file.filename", getHistoryFileLocation());
        props.setProperty("offset.storage.file.filename", getOffsetFileLocation());

        props.setProperty("database.hostname", host);
        props.setProperty("database.port", String.valueOf(port));
        props.setProperty("database.user", user);
        props.setProperty("database.password", password);
        props.setProperty("database.dbname", dbname);

        props.setProperty("log.mining.strategy", "online_catalog");
        props.setProperty("snapshot.mode", "schema_only");

        props.setProperty("database.history.skip.unparseable.ddl", Boolean.toString(true));
        props.setProperty("database.history.store.only.captured.tables.ddl", Boolean.toString(true));

        props.setProperty("database.server.name", "server1");
        props.setProperty("name", "oracle_cdc_engine");

        props.setProperty("schema.include.list", user);
        Set<String> schemaTables = new HashSet<>();
        for (String table : tables.split(",")) {
            schemaTables.add(user + "." + table);
        }
        props.setProperty("table.include.list", String.join(",", schemaTables));

        return props;
    }
}
