package com.tbyf.oraclecdc;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class Channel {

    private final BlockingQueue<RecordChange> queue;

    public Channel(int capacity) {
        this.queue = new ArrayBlockingQueue<>(capacity);
    }

    public void put(RecordChange recordChange) {
        try {
            queue.put(recordChange);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public List<RecordChange> takeAll() {
        List<RecordChange> result = new ArrayList<>();
        // todo 暂定最多一次拿2048条变更记录
        queue.drainTo(result, 2048);
        return result;
    }

    public RecordChange take() {
        try {
            return queue.take();
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }
}
