package com.tbyf.oraclecdc;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class Config {

    public static String SOURCE_HOST = "172.16.51.95";
    public static int SOURCE_PORT = 1521;
    public static String SOURCE_DB_NAME = "ORCL";
    public static String SOURCE_USER = "datacenter";
    public static String SOURCE_PASSWORD = "data";
    public static String TARGET_URL = "jdbc:oracle:thin:@172.16.51.95:1521:ORCL";
    public static String TARGET_USER = "datacenter";
    public static String TARGET_PASSWORD = "data";

    public static Properties DEBEZIUM_PROPERTIES = new Properties();
    private static final String DEBEZIUM_PROPERTY_PREFIX = "debezium.";

    public static void init(String configLocation) {
        try (FileInputStream is = new FileInputStream(configLocation)) {
            Properties props = new Properties();
            props.load(is);
            SOURCE_HOST = props.getProperty("source.host");
            SOURCE_PORT = Integer.parseInt(props.getProperty("source.port"));
            SOURCE_DB_NAME = props.getProperty("source.dbname");
            SOURCE_USER = props.getProperty("source.user");
            SOURCE_PASSWORD = props.getProperty("source.password");
            TARGET_URL = props.getProperty("target.url");
            TARGET_USER = props.getProperty("target.user");
            TARGET_PASSWORD = props.getProperty("target.password");
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = (String) entry.getKey();
                if (key.startsWith(DEBEZIUM_PROPERTY_PREFIX)) {
                    DEBEZIUM_PROPERTIES.put(key.substring(DEBEZIUM_PROPERTY_PREFIX.length()), entry.getValue());
                }
            }
        } catch (IOException e) {
            throw new IllegalStateException("读取配置文件失败", e);
        }
    }
}
