package com.tbyf.oraclecdc;

import java.util.Map;

public class RecordChange {

    private String schema;
    private String table;

    private Map<String, Object> before;
    private Map<String, Object> after;
    private OpType opType;

    public String getSchema() {
        return schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTable() {
        return table;
    }

    public void setTable(String table) {
        this.table = table;
    }


    public Map<String, Object> getBefore() {
        return before;
    }

    public void setBefore(Map<String, Object> before) {
        this.before = before;
    }

    public Map<String, Object> getAfter() {
        return after;
    }

    public void setAfter(Map<String, Object> after) {
        this.after = after;
    }

    public OpType getOpType() {
        return opType;
    }

    public void setOpType(OpType opType) {
        this.opType = opType;
    }

    public enum OpType {
        CREATE,
        DELETE,
        UPDATE
    }

    @Override
    public String toString() {
        return "RecordChange{" +
                "schema='" + schema + '\'' +
                ", table='" + table + '\'' +
                ", before=" + before +
                ", after=" + after +
                ", opType=" + opType +
                '}';
    }
}
