package com.tbyf.oraclecdc;

public class Main {

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("请指定配置文件");
            return;
        }

        Config.init(args[0]);

        CdcProperties cdcProperties = new CdcProperties();
        cdcProperties.setHost(Config.SOURCE_HOST);
        cdcProperties.setPort(Config.SOURCE_PORT);
        cdcProperties.setDbname(Config.SOURCE_DB_NAME);
        cdcProperties.setUser(Config.SOURCE_USER);
        cdcProperties.setPassword(Config.SOURCE_PASSWORD);

        cdcProperties.setTables("MZGH_NYSPBMX");

        OracleCdcEngine engine = new OracleCdcEngine(cdcProperties);

        RecordChangeHandler recordChangeHandler = new AppointmentQuotaSynchronizer();
        engine.setRecordChangeHandler(recordChangeHandler);

        engine.init();
        engine.start();

        Runtime.getRuntime().addShutdownHook(
                new Thread(() -> {
                    engine.stop();
                    recordChangeHandler.close();
                }, "oracle_cdc_engine_shutdown_hook"));
    }


}
