package com.tbyf.his.web.controller.adapter;

import com.tbyf.his.adapter.domain.AdapterPublishTable;
import com.tbyf.his.adapter.domain.QueryAdapterTableVo;
import com.tbyf.his.adapter.service.AdapterPublishTableService;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Author:lph
 * Date:2022/11/16 15:40
 **/
@RestController
@RequestMapping("/adapter/table")
public class AdapterPublishTableController extends BaseController {

    @Autowired
    AdapterPublishTableService adapterPublishTableService;

    @PostMapping("/add")
    public AjaxResult insertSelective(@RequestBody AdapterPublishTable adapterPublishTable) {
        return toAjax(adapterPublishTableService.insertSelective(adapterPublishTable));
    }

    @GetMapping("/getPublishTableBySource")
    public TableDataInfo selectBySourceTableName(QueryAdapterTableVo queryAdapterTableVo) {
        startPage();
        return getDataTable(adapterPublishTableService.selectBySourceTableName(queryAdapterTableVo));
    }

    @GetMapping("/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable(value = "id") Long id) {
        return AjaxResult.success(adapterPublishTableService.selectTableById(id));
    }

    @PutMapping("/updateTable")
    public AjaxResult updateAdapterTable(@RequestBody AdapterPublishTable record) {
        return toAjax(adapterPublishTableService.updateAdapterTable(record));
    }

    @DeleteMapping("/deleteTable/{id}")
    public AjaxResult deleteAdapterTable(@PathVariable("id") Long id) {
        adapterPublishTableService.deleteAdapterTable(id);
        return AjaxResult.success();
    }
}
