package com.tbyf.his.adapter.service.impl;

import com.tbyf.his.adapter.domain.AdapterPublishTable;
import com.tbyf.his.adapter.domain.AdapterPublishTask;
import com.tbyf.his.adapter.domain.QueryAdapterTableVo;
import com.tbyf.his.adapter.mapper.AdapterPublishColumnMapper;
import com.tbyf.his.adapter.mapper.AdapterPublishTableMapper;
import com.tbyf.his.adapter.mapper.AdapterPublishTaskMapper;
import com.tbyf.his.adapter.service.AdapterPublishTableService;
import com.tbyf.his.adapter.util.AdapterConstant;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.common.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * Author:lph
 * Date:2022/11/16 15:48
 **/
@DataSource(value = DataSourceType.SLAVE)
@Service
public class AdapterPublishTableServiceImpl implements AdapterPublishTableService {

    @Autowired
    private AdapterPublishTableMapper adapterPublishTableMapper;

    @Autowired
    private AdapterPublishColumnMapper adapterPublishColumnMapper;

    @Autowired
    private AdapterPublishTaskMapper adapterPublishTaskMapper;

    @Override
    public int insertSelective(AdapterPublishTable adapterPublishTable) {
        return adapterPublishTableMapper.insertSelective(adapterPublishTable);
    }

    @Override
    public List<AdapterPublishTable> selectBySourceTableName(QueryAdapterTableVo queryAdapterTableVo) {
        return adapterPublishTableMapper.selectBySourceTableName(queryAdapterTableVo);
    }

    @Override
    public AdapterPublishTable selectTableById(Long id) {
        return adapterPublishTableMapper.selectByPrimaryKey(id);
    }

    @Override
    public int updateAdapterTable(AdapterPublishTable adapterPublishTable) {
        return adapterPublishTableMapper.updateByPrimaryKeySelective(adapterPublishTable);
    }

    @Override
    public void deleteAdapterTable(Long id) {
        AdapterPublishTable adapterPublishTable = adapterPublishTableMapper.selectByPrimaryKey(id);

        //判断任务是否已启动
        AdapterPublishTask adapterPublishTask = adapterPublishTaskMapper.selectTaskByPublishTableNameAndSourceName(adapterPublishTable.getPublishTableName(), adapterPublishTable.getSourceName());
        if (!Objects.isNull(adapterPublishTask) && AdapterConstant.TASK_STATUS_ENABLE.equals(adapterPublishTask.getStatus())) {
            throw new ServiceException("发布表" + adapterPublishTable.getPublishTableName() + "的任务已启动, 请先停止任务");
        }

        //删除已发布任务
        if (!Objects.isNull(adapterPublishTask)) {
            adapterPublishTaskMapper.deleteAdapterPublishTaskById(adapterPublishTask.getId());
        }

        //删除已发布列
        adapterPublishColumnMapper.deleteBySourceTableNameAndSourceNameAndSourceName(adapterPublishTable.getSourceTableName(), adapterPublishTable.getSourceName());

        adapterPublishTableMapper.deleteByPrimaryKey(id);
    }
}
